#!/bin/sh

if [ $# -ne 1 ]; then
  echo "usage. $0 filename"
  exit 255
fi

DIR=`dirname "${0}"`

FILENAME=$1

IP_ADDRESS=`"${DIR}/get_parameter/get_ip_from_csv.sh" "${FILENAME}"`
SUBNET_MASK=`"${DIR}/get_parameter/get_subnet_mask_from_csv.sh" "${FILENAME}"`

echo IP_ADDRESS: ${IP_ADDRESS}
echo SUBNET_MASK: ${SUBNET_MASK}

if [ ${IP_ADDRESS} = "0.0.0.0" ]; then                              
  ifconfig eth0:1 down
  exit 0
else                                                  
  ifconfig eth0:1 ${IP_ADDRESS} netmask ${SUBNET_MASK}
fi
